#ifndef __DM_CHARCONV_H__
#define __DM_CHARCONV_H__

/**
 *
 * \file        charconv.h
 *
 * \brief       Routines for dealing with converting between different
 *              character sets, such as UTF-8, ASCII, UNICODE, etc.
 *
 * \author      Pete McCormick
 *
 * \date        02/22/2006
 *
 * \note
 *
 */

#ifdef __cplusplus
extern "C" {
#endif
////////////////////////////////////////////////////////////////////////////////

#include "dm_nutypedefs.h"

////////////////////////////////////////////////////////////////////////////////

typedef enum
{
    UTF8_TO_ASCII,
    UTF8_TO_UNICODE
} UTF8OPT;

////////////////////////////////////////////////////////////////////////////////

extern UTF8OPT UTF8GetOption(void);
extern void UTF8ToAscii(char* p, UINT32 destLen);
extern void UTF8ToUnicode(UINT16 * pDest, char * p, UINT32 destLen);
extern void AsciiToIso8859(char * p);
#ifdef __cplusplus
}
#endif

#endif  //__DM_CHARCONV_H__

